/*
 * Decompiled with CFR 0.152.
 */
package net.darkblade.mini_pekka;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;
import net.darkblade.mini_pekka.client.ModBlockEntities;
import net.darkblade.mini_pekka.client.render.MiniPekkaRenderer;
import net.darkblade.mini_pekka.server.block.ModBlocks;
import net.darkblade.mini_pekka.server.entity.MPekkaEntities;
import net.darkblade.mini_pekka.server.entity.MiniPekka;
import net.darkblade.mini_pekka.server.items.ModItems;
import net.darkblade.mini_pekka.sounds.ModSounds;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.slf4j.Logger;

@Mod(value="mpekka")
public class MiniPekkaMod {
    public static final String MODID = "mpekka";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MiniPekkaMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::onEntityAttributeCreation);
        MPekkaEntities.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                Field f = ObfuscationReflectionHelper.findField(BlockEntityType.class, (String)"validBlocks");
                Set oldSet = (Set)f.get(BlockEntityType.f_58931_);
                LinkedHashSet<Block> newSet = new LinkedHashSet<Block>(oldSet);
                newSet.add((Block)ModBlocks.MINI_PK_HEAD.get());
                newSet.add((Block)ModBlocks.MINI_PK_WALL_HEAD.get());
                f.set(BlockEntityType.f_58931_, newSet);
            }
            catch (Throwable t) {
                LOGGER.error("[mpekka] Could not replace SKULL validBlocks", t);
            }
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    private void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)MPekkaEntities.MPEKKA.get(), MiniPekka.createAttributes().m_22265_());
    }

    @Mod.EventBusSubscriber(modid="mpekka", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        }

        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)MPekkaEntities.MPEKKA.get()), MiniPekkaRenderer::new);
        }

        @SubscribeEvent
        public static void entityAttributeEvent(EntityAttributeCreationEvent event) {
        }
    }
}

